/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class LogCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"log").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandLog))).executes(context -> LogCommand.listLogs((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(c -> LogCommand.unsubFromAll((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9214()))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265((Iterable)((class_2168)c.getSource()).method_9262(), (SuggestionsBuilder)b)).executes(c -> LogCommand.unsubFromAll((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"player")))));
        literalargumentbuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"log name", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265(LoggerRegistry.getLoggerNames(), (SuggestionsBuilder)b)).executes(c -> LogCommand.toggleSubscription((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9214(), StringArgumentType.getString((CommandContext)c, (String)"log name")))).then(class_2170.method_9247((String)"clear").executes(c -> LogCommand.unsubFromLogger((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9214(), StringArgumentType.getString((CommandContext)c, (String)"log name"))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"option", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> class_2172.method_9253((String[])(LoggerRegistry.getLogger(StringArgumentType.getString((CommandContext)c, (String)"log name")) == null ? new String[]{} : LoggerRegistry.getLogger(StringArgumentType.getString((CommandContext)c, (String)"log name")).getOptions()), (SuggestionsBuilder)b)).executes(c -> LogCommand.subscribePlayer((class_2168)c.getSource(), ((class_2168)c.getSource()).method_9214(), StringArgumentType.getString((CommandContext)c, (String)"log name"), StringArgumentType.getString((CommandContext)c, (String)"option")))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265((Iterable)((class_2168)c.getSource()).method_9262(), (SuggestionsBuilder)b)).executes(c -> LogCommand.subscribePlayer((class_2168)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"player"), StringArgumentType.getString((CommandContext)c, (String)"log name"), StringArgumentType.getString((CommandContext)c, (String)"option"))))));
        dispatcher.register(literalargumentbuilder);
    }

    private static int listLogs(class_2168 source) {
        class_3222 player;
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException e) {
            Messenger.m(source, "For players only");
            return 0;
        }
        Map<String, String> subs = LoggerRegistry.getPlayerSubscriptions(source.method_9214());
        if (subs == null) {
            subs = new HashMap<String, String>();
        }
        ArrayList<String> all_logs = new ArrayList<String>(LoggerRegistry.getLoggerNames());
        Collections.sort(all_logs);
        Messenger.m((class_1657)player, "w _____________________");
        Messenger.m((class_1657)player, "w Available logging options:");
        for (String lname : all_logs) {
            ArrayList<Object> comp = new ArrayList<Object>();
            String color = subs.containsKey(lname) ? "w" : "g";
            comp.add("w  - " + lname + ": ");
            Logger logger = LoggerRegistry.getLogger(lname);
            String[] options = logger.getOptions();
            if (options.length == 0) {
                if (subs.containsKey(lname)) {
                    comp.add("l Subscribed ");
                } else {
                    comp.add(color + " [Subscribe] ");
                    comp.add("^w subscribe to " + lname);
                    comp.add("!/log " + lname);
                }
            } else {
                for (String option : logger.getOptions()) {
                    if (subs.containsKey(lname) && subs.get(lname).equalsIgnoreCase(option)) {
                        comp.add("l [" + option + "] ");
                        continue;
                    }
                    comp.add(color + " [" + option + "] ");
                    comp.add("^w subscribe to " + lname + " " + option);
                    comp.add("!/log " + lname + " " + option);
                }
            }
            if (subs.containsKey(lname)) {
                comp.add("nb [X]");
                comp.add("^w Click to unsubscribe");
                comp.add("!/log " + lname);
            }
            Messenger.m((class_1657)player, comp.toArray(new Object[0]));
        }
        return 1;
    }

    private static int unsubFromAll(class_2168 source, String player_name) {
        class_3222 player = source.method_9211().method_3760().method_14566(player_name);
        if (player == null) {
            Messenger.m(source, "r No player specified");
            return 0;
        }
        for (String logname : LoggerRegistry.getLoggerNames()) {
            LoggerRegistry.unsubscribePlayer(player_name, logname);
        }
        Messenger.m(source, "gi Unsubscribed from all logs");
        return 1;
    }

    private static int unsubFromLogger(class_2168 source, String player_name, String logname) {
        class_3222 player = source.method_9211().method_3760().method_14566(player_name);
        if (player == null) {
            Messenger.m(source, "r No player specified");
            return 0;
        }
        if (LoggerRegistry.getLogger(logname) == null) {
            Messenger.m(source, "r Unknown logger: ", "rb " + logname);
            return 0;
        }
        LoggerRegistry.unsubscribePlayer(player_name, logname);
        Messenger.m(source, "gi Unsubscribed from " + logname);
        return 1;
    }

    private static int toggleSubscription(class_2168 source, String player_name, String logName) {
        class_3222 player = source.method_9211().method_3760().method_14566(player_name);
        if (player == null) {
            Messenger.m(source, "r No player specified");
            return 0;
        }
        if (LoggerRegistry.getLogger(logName) == null) {
            Messenger.m(source, "r Unknown logger: ", "rb " + logName);
            return 0;
        }
        boolean subscribed = LoggerRegistry.togglePlayerSubscription(player_name, logName);
        if (subscribed) {
            Messenger.m(source, "gi " + player_name + " subscribed to " + logName + ".");
        } else {
            Messenger.m(source, "gi " + player_name + " unsubscribed from " + logName + ".");
        }
        return 1;
    }

    private static int subscribePlayer(class_2168 source, String player_name, String logname, String option) {
        class_3222 player = source.method_9211().method_3760().method_14566(player_name);
        if (player == null) {
            Messenger.m(source, "r No player specified");
            return 0;
        }
        if (LoggerRegistry.getLogger(logname) == null) {
            Messenger.m(source, "r Unknown logger: ", "rb " + logname);
            return 0;
        }
        if (!LoggerRegistry.getLogger(logname).isOptionValid(option)) {
            Messenger.m(source, "r Invalid option: ", "rb " + option);
            return 0;
        }
        LoggerRegistry.subscribePlayer(player_name, logname, option);
        if (option != null) {
            Messenger.m(source, "gi Subscribed to " + logname + "(" + option + ")");
        } else {
            Messenger.m(source, "gi Subscribed to " + logname);
        }
        return 1;
    }
}

